<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    include "include/controlloLogin.php";
    
    $elementiPerPagina = isset($_GET["elementiPerPagina"]) ? filter_input(INPUT_GET,"elementiPerPagina",FILTER_SANITIZE_NUMBER_INT) : 25;
    $cerca             = isset($_GET["cerca"]) ? filter_input(INPUT_GET,"cerca",FILTER_SANITIZE_ADD_SLASHES) : "";
    
    if(isset($_GET["idGruppo"])) {
        $tipoRicerca= "utentiGruppi";
        $idGruppo   = isset($_GET["idGruppo"]) ? filter_input(INPUT_GET,"idGruppo",FILTER_SANITIZE_ADD_SLASHES) : "0";
        $parametriAggiuntiviFormRicerca = array("idGruppo"=>$idGruppo);
        $datiGruppo = $geecomDb->leggiSingolaRiga("geec_gruppi",$idGruppo);
        
        $intestazioneTabella = "Utenti del gruppo {$datiGruppo["nome"]}";
        $linkPaginaPrecedente= "gestioneGruppi.php";
        $parametriRicerca    = array("idGruppo"=>$idGruppo);
        $parametri           = array("tabella"=>"geec_gruppiUtenti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    }
    else if(isset($_GET["etichetta"])) {
        $tipoRicerca= "etichetta";
        $etichetta     = filter_input(INPUT_GET,"etichetta",FILTER_SANITIZE_ADD_SLASHES);
        $parametriAggiuntiviFormRicerca = array("etichetta"=>$etichetta);
        $datiEtichetta = $geecomDb->leggiSingolaRiga("geecAd_etichette",$etichetta,"nome");
        $intestazioneTabella = "Utenti con etichetta {$datiEtichetta["nome"]}";
        $linkPaginaPrecedente= "gestioneEtichette.php";
        $parametriRicerca    = ($cerca!="") ? array("etichetta"=>$etichetta,"nome"=>$cerca,"cognome"=>$cerca,"email"=>$cerca) : array("etichetta"=>$etichetta);
        $parametri           = array("tabella"=>"geec_utenti", "elementiPerPagina"=>$elementiPerPagina,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
    }
    
    
    $impostazioniRicerca["ordinamentoBase"] = "";
    $ricerca = new Ricerca($geecomDb, $parametri, $impostazioniRicerca,"elencoUtenti.php");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Amministrazione di Geecom Admin - elenco utenti</title>

    <?php
        include "include/cssBaseAreaAmministrativa.php";
    ?>
</head>

<body>
   
    <header>
        <?php  
            include "include/barraSuperiore.php";

            include "include/header.php";

            include "include/barraMenu.php";
        ?>
    </header>

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div id="contenutoPrincipale" class="row">
                <?php
                    if(isset($_GET["status"])) {
                        if($_GET["status"]==1) {
                                echo"<p class=\"alert alert-success\">Utente creato</p>";
                        }
                        else if($_GET["status"]==2) {
                                echo"<p class=\"alert alert-success\">Utente modificato</p>";
                        }
                        else if($_GET["status"]==4) {
                                echo"<p class=\"alert alert-success\">Stato dell'amministratore modificato</p>";
                        }
                        else if($_GET["status"]==400) {
                                echo"<p class=\"alert alert-danger\">Indirizzo email già esistente</p>";
                        }
                        else { //status = 5
                                echo"<p class=\"alert alert-success\">Utente eliminato</p>";
                        }
                    }
                ?>
                <div class="col py-4">
                    <div class="card mb-4 box-shadow-lite">
                        <div class="card-header">
                            <span class="card-title mr-2"><?php echo $intestazioneTabella ?></span>
                            <a href="<?php echo $linkPaginaPrecedente ?>" class="btn btn-sm btn-outline-primary" >
                                <i class="fas fa-arrow-left mr-2"></i>Torna all'elenco
                            </a>
                        </div>   
                        <div class="card-body">
                            <div class="d-flex justify-content-between mb-3">
                                <?php
                                    $ricerca->stampaSelectNumeroElementi($cerca);
                                    $ricerca->stampaFormRicerca($cerca,$parametriAggiuntiviFormRicerca);
                                ?>
                            </div>
                            <div class="table-responsive">
                            
                                <?php

                                    if(isset($_GET["pag"])) {
                                        $ris = $ricerca->eseguiRicerca($_GET["pag"]);
                                    }
                                    else {
                                        $ris = $ricerca->eseguiRicerca(1);
                                    }
                                    
                                    $colonne = array("ID","Nome","Cognome","Email","Ruolo","Stato","");
                                    $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                    $tabella->setTipo("normale");
                                    while($datiGruppoUtente = $ris->fetch_assoc()) {
                                        if($tipoRicerca=="utentiGruppi") {
                                            $utente = $geecomDb->leggiSingolaRiga("geec_utenti",$datiGruppoUtente["idUtente"]);
                                        }
                                        else {
                                            $utente = $datiGruppoUtente;
                                        }
                                        
                                        $nomeCognomeEscape = filter_var($utente["nome"]." ".$utente["cognome"],FILTER_SANITIZE_ADD_SLASHES);
                                        if($utente["stato"]=="sospeso") {
                                            $azioni = array("attiva"=>"amministratori/sospendiAmministratore.php?id={$utente["id"]}","modifica"=>"creaUtente.php?id={$utente["id"]}","elimina"=>"eliminaUtente({$utente["id"]},'$nomeCognomeEscape')");
                                        }
                                        else {
                                            $azioni = array("sospendi"=>"amministratori/sospendiAmministratore.php?id={$utente["id"]}","modifica"=>"creaUtente.php?id={$utente["id"]}","elimina"=>"eliminaUtente({$utente["id"]},'$nomeCognomeEscape')");
                                        }
                                        $tabella->aggiungiNuovaRiga(array($utente["id"],$utente["nome"],$utente["cognome"],$utente["email"],$utente["ruolo"],$utente["stato"]),$azioni);
                                    }
                                    $tabella->stampa("rigaUtente",0);
                                    $ricerca->stampaPaginazione(true,"gestioneUtenti.php");
                                ?>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>
    
    	
        <div class="modal fade" id="modalEliminaUtente" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare l'utente?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="elementoDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneUtente()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
       
    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>


	
    <script type="text/javascript">
            
            function eliminaUtente(id,nomeElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaUtente').modal('show');
            }
            
            function eseguiEliminazioneUtente() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerUtenti.php",
                    data:{
                        operazione:"eliminaUtente",
                        idUtente:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("rigaUtente"+id).className = "d-none";
                            $('#modalEliminaUtente').modal('hide');
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
    </script>
</body>
</html>